@echo off
title CLSTEAM FIVEM OPTIMIZER
setlocal enabledelayedexpansion

:: ADMIN CHECK
NET SESSION >nul 2>&1
if %errorlevel% NEQ 0 (
    echo ====================================
    echo   ADMIN PRIVILEGES REQUIRED
    echo ====================================
    echo Right-click this file → Run as administrator
    pause
    exit /b
)

:: HEADER
cls
echo ================================================
echo        CLSTEAM FIVEM OPTIMIZER
echo ================================================
echo Searching for FiveM_GTAProcess.exe...
echo.

:: FAST SEARCH
set "found_exe="

for %%A in (
"%localappdata%\FiveM\FiveM.app\bin\FiveM_GTAProcess.exe"
"%localappdata%\FiveM\FiveM.app\cache\game\FiveM_GTAProcess.exe"
"%programfiles%\FiveM\FiveM_GTAProcess.exe"
"%programfiles(x86)%\FiveM\FiveM_GTAProcess.exe"
"C:\FiveM\FiveM_GTAProcess.exe"
"D:\FiveM\FiveM_GTAProcess.exe"
"E:\FiveM\FiveM_GTAProcess.exe"
"F:\FiveM\FiveM_GTAProcess.exe"
) do (
    if exist %%A (
        set "found_exe=%%A"
        set "fivem_path=%%~dpA"
        goto FOUND
    )
)

:: DRIVE SCAN
for %%D in (C D E F) do (
    for /f "delims=" %%F in ('dir "%%D:\FiveM_GTAProcess.exe" /s /b 2^>nul') do (
        set "found_exe=%%F"
        set "fivem_path=%%~dpF"
        goto FOUND
    )
)

if not defined found_exe (
    echo ERROR: FiveM_GTAProcess.exe NOT FOUND!
    echo Make sure FiveM is installed.
    pause
    exit /b
)

:FOUND
echo Found FiveM at:
echo !found_exe!
echo.

:: BACKUP
if not exist "!fivem_path!FiveM_GTAProcess.exe.backup" (
    copy "!found_exe!" "!fivem_path!FiveM_GTAProcess.exe.backup" >nul
    echo Backup created.
) else (
    echo Backup already exists.
)
echo.

:: ================================
:: APPLY PERFORMANCE OPTIMIZATION
:: ================================

echo Applying GPU Performance Settings...
set "regbase=HKCU\Software\Microsoft\DirectX\UserGpuPreferences"
reg add "%regbase%" /v "FiveM" /t REG_SZ /d "GpuPreference=2;PerfPreference=2" /f >nul
reg add "%regbase%" /v "DirectXUserGlobalSettings" /t REG_SZ /d "HighPerfMode=1" /f >nul
echo GPU optimization applied.
echo.

echo Applying CPU + Process Settings...
set "regcpu=HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\FiveM_GTAProcess.exe"

reg add "%regcpu%" /v CpuPriorityClass /t REG_DWORD /d 3 /f >nul
reg add "%regcpu%" /v IoPriority /t REG_DWORD /d 3 /f >nul
reg add "%regcpu%" /v MemPriority /t REG_DWORD /d 5 /f >nul
reg add "%regcpu%" /v DisableFullscreenOptimizations /t REG_DWORD /d 1 /f >nul
reg add "%regcpu%" /v HighDpiAware /t REG_DWORD /d 1 /f >nul
reg add "%regcpu%" /v Affinity /t REG_DWORD /d 0 /f >nul

echo CPU, Memory, I/O, DPI and Fullscreen settings applied.
echo.

echo ================================================
echo        FIVEM OPTIMIZATION COMPLETE!
echo ================================================
echo ALL PERFORMANCE SETTINGS HAVE BEEN APPLIED.
echo.
echo Optimizations Applied:
echo   ✓ High GPU Performance Mode
echo   ✓ DirectX High Performance Mode
echo   ✓ High CPU Priority
echo   ✓ High Memory Priority
echo   ✓ High I/O Priority
echo   ✓ Fullscreen Optimizations Disabled
echo   ✓ High DPI Scaling Enabled
echo   ✓ All CPU Cores Allowed (Affinity)
echo.
echo Your FiveM is now fully optimized!
echo ================================================
echo Press ENTER to exit...
pause >nul
exit /b
